<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Question extends Model 
{

    protected $table = 'questions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('content', 'type', 'is_required', 'placeholder', 'regex_id', 'section_id', 'is_visible', 'order');

    public function section()
    {
        return $this->belongsTo('Section');
    }

    public function regex()
    {
        return $this->belongsTo('Regex');
    }

    public function options()
    {
        return $this->hasMany('Option');
    }

    public function answers()
    {
        return $this->hasMany('Answer');
    }

    public function attachments()
    {
        return $this->hasMany('Attachment');
    }

}